package gov.va.med.mhv.vitals.web.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.vitals.dto.BodyWeightReadingDTO;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.util.WebUtility;

@ManagedBean
@Component
@Scope("session")
public class BodyWeightController extends AbstractController {

	private static final long serialVersionUID = -4411096279495705994L;
	private static Logger log = LogManager.getLogger(BodyWeightController.class);
	private List<BodyWeightReadingDTO> bwreadings = new ArrayList<BodyWeightReadingDTO>();
	private BodyWeightReadingDTO selectedBWReading = new BodyWeightReadingDTO();
	private BodyWeightReadingDTO newBWReading = new BodyWeightReadingDTO();
	private static final String TITLE = "Body Weight";
	private static final String XAXIS = "Date";
	private static final String YAXIS = "lbs";

	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		DataTable bwTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("bodyweightForm:bweightList");
		if (!FacesContext.getCurrentInstance().isPostback()) {
			resetMessages();
			if (userprofileId != null) {
				bwreadings = findBWReadings(userprofileId);
			}
			setRowsPerPage(10);
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
		else{
			if(sortColumn != null && sortBy != null){
				bwTable.setValueExpression("sortBy", sortColumn);
				bwTable.setSortOrder(sortBy);
			} 
		}
	}

	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}
	
	private List<BodyWeightReadingDTO> findBWReadings(Long userprofileId) {
		List<BodyWeightReadingDTO> dtoList = null;
		try {

			dtoList = this.vitalSignsService.getBWReadingsForUser(userprofileId);

		} catch (Exception e) {
			log.error("Error in Find Bodyweight readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return dtoList;
	}

	public String showDetail(BodyWeightReadingDTO bodyWeightReadingDTO) {
		resetMessages();
		selectedBWReading = bodyWeightReadingDTO;
		setHourMinute(selectedBWReading);
		return "bodyWeight";
	}
	
	public String editDisplay(BodyWeightReadingDTO bodyWeightReadingDTO) {
		resetMessages();
		selectedBWReading = bodyWeightReadingDTO;
		setHourMinute(selectedBWReading);
		return "editBWDisplay";
	}
	
	public String resetEditDisplay(){
		return "editBWDisplay";
	}

	public String deleteDisplay(BodyWeightReadingDTO bodyWeightReadingDTO) {
		resetMessages();
		selectedBWReading = bodyWeightReadingDTO;
		setHourMinute(selectedBWReading);
		setDeleteOrigin("tableView");
		return "deleteBWDisplay";
	}

	public String deleteRecordDisplay() {
		resetMessages();
		setDeleteOrigin(null);
		return "deleteBWDisplay";
	}

	private void setHourMinute(BodyWeightReadingDTO selectedBWReading) {
		String dateTime = WebUtility.dateToString(selectedBWReading.getReading(), HOUR_MINUTE);
		if (!dateTime.equals(DEFAULT_DATETIME)) {
			selectedBWReading.setHour(WebUtility.dateToString(selectedBWReading.getReading(), HOURS));
			selectedBWReading.setMinute(WebUtility.dateToString(selectedBWReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newBWReading = new BodyWeightReadingDTO();
		newBWReading.setReading(new Date());
		return "addBWDisplay";
	}

	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			bwreadings = findBWReadings(userprofileId);
		}
		newBWReading = new BodyWeightReadingDTO();
		newBWReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().handleNavigation(context, null,
				"/views/bodyweight/addBWDisplay.xhtml");
		return null;
	}
	
	public String dashboardViewMore() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			bwreadings = findBWReadings(userprofileId);
		}
		return "/views/bodyweight/bodyWeightList";
	}

	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String bwid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bwid");
		Long userProfileId = getUserProfileId();
		if (bwid != null && userProfileId != null) {
			Long id = Long.valueOf(bwid);
			selectedBWReading = getBWReadingById(userProfileId, id);
		}
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().handleNavigation(context, null,
				"/views/bodyweight/bodyWeight.xhtml");
		return null;
	}

	private BodyWeightReadingDTO getBWReadingById(Long userProfileId, Long id) {
		BodyWeightReadingDTO dto = null;
		try {

			dto = this.vitalSignsService.getBWReadingByid(userProfileId, id);

		} catch (Exception e) {
			log.error("Error in Find BW reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return dto;
	}

	public String delete() {
		String outcome = null;
		String bwid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bwid");
		Long userProfileId = getUserProfileId();

		try {
			if (bwid != null && userProfileId != null) {
				Long id = Long.valueOf(bwid);

				this.vitalSignsService.deleteBodyWeightReading(userProfileId, id);
				bwreadings = findBWReadings(userprofileId);
				deleteMessage = true;
				outcome = "bodyWeightList";
			}
		} catch (Exception e) {
			log.error("Failed to Delete Bodyweight record", e);

			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return outcome;
	}

	public String save() {
		String outcome = null;
		try {
			if (saveBWReading().getBodyweightID() != null) {
				outcome = "bodyWeightList";
				bwreadings = findBWReadings(userprofileId);
				saveMessage = true;
			}
		} catch (MHVException e) {
			log.error("Failed to Save Bodyweight record", e);
			if (e.getValidationErrorMessages() != null) {
				addValidationMessages(e.getValidationErrorMessages());
			} else {
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
		return outcome;
	}

	public BodyWeightReadingDTO saveBWReading() throws MHVException {
		resetMessages();
		String bwid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bwid");
		Long id = null;
		BodyWeightReadingDTO bwreading = null;
		if (bwid != null) {
			id = Long.valueOf(bwid);
			bwreading = getSelectedBWReading();
		} else {
			bwreading = getNewBWReading();
		}

		prepareBWReading(id, bwreading);
		Long bwrId = this.vitalSignsService.saveBodyWeightReading(bwreading);
		bwreading.setBodyweightID(bwrId);
		return bwreading;

	}

	private BodyWeightReadingDTO prepareBWReading(Long id, BodyWeightReadingDTO bwreading) {
		Date dateTime = null;
		if (bwreading.getReading() != null) {
			if (bwreading.getHour() == null && bwreading.getMinute() == null) {
				dateTime = WebUtility.getDaTeTime(bwreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			} else {
				dateTime = WebUtility.getDaTeTime(bwreading.getReading(), bwreading.getHour(), bwreading.getMinute());
			}
		}
		bwreading.setReading(dateTime);
		bwreading.setUserprofileId(getUserProfileId());
		return bwreading;
	}

	public String saveAndAdd() {
		String outcome = null;
		try {
			if (saveBWReading().getBodyweightID() != null) {
				outcome = "addBWDisplay";
				saveAndAddMessage = true;
				bwreadings = findBWReadings(userprofileId);
				newBWReading = new BodyWeightReadingDTO();
				newBWReading.setReading(new Date());
			}

		} catch (MHVException e) {
			log.error("Failed to Save Bodyweight record", e);
			if (e.getValidationErrorMessages() != null) {
				addValidationMessages(e.getValidationErrorMessages());
			} else {
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
		return outcome;
	}

	public String updateLineModel() {
		return "bodyWeightGraph";
	}

	public StreamedContent getJchart() {
		StreamedContent content = null;
		try {
			content = createChart(TITLE, XAXIS, YAXIS);
		} catch (Exception e) {
			log.error("Failed to create Chart", e);
		}
		return content;
	}

	protected XYDataset createDataset(Set<String> uniqueYears) {
		TimeSeriesCollection dataset = new TimeSeriesCollection();
		TimeSeries series1 = new TimeSeries(YAXIS);
		String period = getPeriod();
		Date startDate = null;
		List<BodyWeightReadingDTO> graphList;
		if (!period.equals(PeriodEnumeration.ALL_DATA.getDescription())) {
			startDate = getStartGraphDate(period);
		}
		if (startDate != null) {
			graphList = getGraphlist(bwreadings, startDate);
		} else {
			graphList = bwreadings;
		}
		for (BodyWeightReadingDTO bwreading : graphList) {
			series1.addOrUpdate(new Day(bwreading.getReading()), bwreading.getBodyweight());
			uniqueYears
					.add(CommonUtility.dateToString(bwreading.getReading(), YYYY_MM_DD_HHMMSS_FORMAT).substring(0, 4));
		}
		dataset.addSeries(series1);
		return dataset;
	}

	private List<BodyWeightReadingDTO> getGraphlist(List<BodyWeightReadingDTO> bwreadings, Date startDate) {
		List<BodyWeightReadingDTO> graphList = new ArrayList<BodyWeightReadingDTO>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for (BodyWeightReadingDTO bwreading : bwreadings) {
			Integer readingValue = Integer.valueOf(CommonUtility.dateToString(bwreading.getReading(), YYYYMMDD_FORMAT));
			if (readingValue >= startdateValue) {
				graphList.add(bwreading);
			}
		}
		return graphList;
	}

	public String printerFriendlySummary(){
		resetMessages();
		return "printBWSummary";
	}

	public List<BodyWeightReadingDTO> getBwreadings() {
		return bwreadings;
	}

	public void setBwreadings(List<BodyWeightReadingDTO> bwreadings) {
		this.bwreadings = bwreadings;
	}

	public BodyWeightReadingDTO getSelectedBWReading() {
		return selectedBWReading;
	}

	public void setSelectedBWReading(BodyWeightReadingDTO selectedBWReading) {
		this.selectedBWReading = selectedBWReading;
	}

	public BodyWeightReadingDTO getNewBWReading() {
		return newBWReading;
	}

	public void setNewBWReading(BodyWeightReadingDTO newBWReading) {
		this.newBWReading = newBWReading;
	}

}
